/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.view;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.command.trigger.SelectSessionViewCommand;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.grid.LightInfo;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractSessionView;
import de.mossgrabers.framework.view.TransposeView;

public class SessionView
extends AbstractSessionView<PushControlSurface, PushConfiguration>
implements TransposeView {
    public SessionView(PushControlSurface surface, IModel model) {
        super("Session", surface, model, 8, 8, true);
        boolean isPush2 = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isPushModern();
        int redLo = isPush2 ? 7 : 7;
        int redHi = isPush2 ? 5 : 5;
        int black = isPush2 ? 0 : 0;
        int white = isPush2 ? 3 : 3;
        int green = isPush2 ? 22 : 22;
        int amber = isPush2 ? 10 : 10;
        LightInfo isRecording = new LightInfo(redHi, redHi, false);
        LightInfo isRecordingQueued = new LightInfo(redHi, black, true);
        LightInfo isPlaying = new LightInfo(green, green, false);
        LightInfo isPlayingQueued = new LightInfo(green, green, true);
        LightInfo hasContent = new LightInfo(amber, white, false);
        LightInfo noContent = new LightInfo(black, -1, false);
        LightInfo recArmed = new LightInfo(redLo, -1, false);
        this.setColors(isRecording, isRecordingQueued, isPlaying, isPlayingQueued, hasContent, noContent, recArmed);
        this.birdColorHasContent = new LightInfo(amber, -1, false);
        this.birdColorSelected = isPlaying;
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            ((SelectSessionViewCommand)((PushControlSurface)this.surface).getButton(ButtonID.SESSION).getCommand()).setTemporary();
        }
        if (this.isBirdsEyeActive()) {
            if (velocity == 0) {
                return;
            }
            int index = note - 36;
            int x = index % this.columns;
            int y = this.rows - 1 - index / this.columns;
            this.onGridNoteBirdsEyeView(x, y, 0);
            return;
        }
        super.onGridNote(note, velocity);
    }

    @Override
    protected boolean handleButtonCombinations(ITrack track, ISlot slot) {
        if (this.isButtonCombination(ButtonID.SELECT)) {
            if (slot.doesExist()) {
                slot.select();
            }
            return true;
        }
        return super.handleButtonCombinations(track, slot);
    }

    @Override
    public boolean isBirdsEyeActive() {
        return ((PushControlSurface)this.surface).isShiftPressed() && ((PushControlSurface)this.surface).isSelectPressed();
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        int scene = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        if (scene < 0 || scene >= 8) {
            return "BUTTON_COLOR_OFF";
        }
        ISceneBank sceneBank = this.model.getSceneBank();
        IScene s = (IScene)sceneBank.getItem(scene);
        if (s.doesExist()) {
            return s.isSelected() ? "COLOR_SELECTED_SCENE" : "COLOR_SCENE";
        }
        return "COLOR_SELECTED_OFF";
    }

    @Override
    public void onOctaveDown(ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.model.getCurrentTrackBank().getSceneBank().selectNextPage();
        }
    }

    @Override
    public void onOctaveUp(ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.model.getCurrentTrackBank().getSceneBank().selectPreviousPage();
        }
    }

    @Override
    public boolean isOctaveUpButtonOn() {
        return this.model.getCurrentTrackBank().getSceneBank().canScrollPageForwards();
    }

    @Override
    public boolean isOctaveDownButtonOn() {
        return this.model.getCurrentTrackBank().getSceneBank().canScrollPageBackwards();
    }

    @Override
    public void resetOctave() {
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        super.onButton(buttonID, event, velocity);
        if (ButtonID.isSceneButton(buttonID) && event == ButtonEvent.UP) {
            ((SelectSessionViewCommand)((PushControlSurface)this.surface).getButton(ButtonID.SESSION).getCommand()).setTemporary();
        }
    }
}

