/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.view;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.view.sequencer.AbstractPolySequencerView;

public class PolySequencerView
extends AbstractPolySequencerView<PushControlSurface, PushConfiguration> {
    public PolySequencerView(PushControlSurface surface, IModel model, boolean useTrackColor) {
        super(surface, model, useTrackColor);
    }

    @Override
    public void onGridNoteLongPress(int note) {
        if (!this.isActive()) {
            return;
        }
        int index = note - 36;
        ((PushControlSurface)this.surface).getButton(ButtonID.get(ButtonID.PAD1, index)).setConsumed();
        int x = index % this.numColumns;
        int y = index / this.numColumns;
        if (y < this.numRows - this.numSequencerRows) {
            return;
        }
        INoteClip clip = this.getClip();
        int step = this.numColumns * (this.numRows - 1 - y) + x;
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), step, 0);
        this.clearEditNotes();
        for (int row = 0; row < 128; ++row) {
            notePosition.setNote(row);
            if (clip.getStep(notePosition).getState() != StepState.START) continue;
            this.editNote(clip, notePosition, true);
        }
    }

    @Override
    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, int channel, int step) {
        boolean isSelectPressed = ((PushControlSurface)this.surface).isSelectPressed();
        NotePosition notePosition = new NotePosition(channel, step, 0);
        if (((PushControlSurface)this.surface).isShiftPressed()) {
            for (int row = 0; row < 128; ++row) {
                notePosition.setNote(row);
                if (clip.getStep(notePosition).getState() != StepState.START) continue;
                this.handleSequencerAreaRepeatOperator(clip, notePosition, 127, !isSelectPressed);
            }
            return true;
        }
        if (isSelectPressed) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.SELECT);
            for (int row = 0; row < 128; ++row) {
                notePosition.setNote(row);
                if (clip.getStep(notePosition).getState() != StepState.START) continue;
                this.editNote(clip, notePosition, true);
            }
            return true;
        }
        return super.handleSequencerAreaButtonCombinations(clip, channel, step);
    }
}

