/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.view;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.view.NoteRepeatSceneHelper;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.IDrumDevice;
import de.mossgrabers.framework.daw.data.IDrumPad;
import de.mossgrabers.framework.daw.data.bank.IDrumPadBank;
import de.mossgrabers.framework.featuregroup.IExpressionView;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.sequencer.AbstractDrumView;

public class DrumView
extends AbstractDrumView<PushControlSurface, PushConfiguration>
implements IExpressionView {
    public DrumView(PushControlSurface surface, IModel model) {
        super("Drum", surface, model, 4, 4, true);
    }

    @Override
    public void onGridNoteLongPress(int note) {
        if (!this.isActive()) {
            return;
        }
        int index = note - 36;
        ((PushControlSurface)this.surface).getButton(ButtonID.get(ButtonID.PAD1, index)).setConsumed();
        int y = index / 8;
        if (y < this.playRows) {
            return;
        }
        int x = index % 8;
        int stepX = 8 * (this.allRows - 1 - y) + x;
        int stepY = this.scales.getDrumOffset() + this.getSelectedPad();
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), stepX, stepY);
        this.editNote(this.getClip(), notePosition, false);
    }

    @Override
    public synchronized void handleSelectButton(int playedPad) {
        IDrumDevice primary = this.model.getDrumDevice();
        if (!primary.hasDrumPads()) {
            return;
        }
        ICursorDevice cd = this.model.getCursorDevice();
        boolean isNested = cd.isNested();
        if (isNested) {
            cd.selectParent();
        }
        if (primary.getPosition() != cd.getPosition()) {
            return;
        }
        IDrumPadBank drumPadBank = primary.getDrumPadBank();
        int scrollPos = drumPadBank.getScrollPosition();
        IDrumPadBank cdDrumPadBank = cd.getDrumPadBank();
        int pageSize = cdDrumPadBank.getPageSize();
        int adjustedPage = playedPad / pageSize * pageSize;
        cdDrumPadBank.scrollTo(scrollPos + adjustedPage, false);
        IDrumPad drumPad = drumPadBank.getItem(playedPad);
        if (drumPad.isSelected()) {
            IDrumPad selectedItem;
            if (isNested && (selectedItem = cdDrumPadBank.getItem(playedPad % pageSize)) != null) {
                selectedItem.enter();
            }
            return;
        }
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        if (!Modes.isLayerMode((Modes)((Object)modeManager.getActiveID())) && !this.model.getBrowser().isActive()) {
            modeManager.setActive(Modes.DEVICE_LAYER);
        }
        drumPad.select();
        this.updateNoteMapping();
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        if (ButtonID.isSceneButton(buttonID) && ((PushControlSurface)this.surface).isPressed(ButtonID.REPEAT)) {
            return NoteRepeatSceneHelper.getButtonColorID((PushControlSurface)this.surface, buttonID);
        }
        return super.getButtonColorID(buttonID);
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (!ButtonID.isSceneButton(buttonID) || event != ButtonEvent.DOWN) {
            return;
        }
        int index = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        if (((PushControlSurface)this.surface).isPressed(ButtonID.REPEAT)) {
            NoteRepeatSceneHelper.handleNoteRepeatSelection((PushControlSurface)this.surface, 7 - index);
            return;
        }
        super.onButton(buttonID, event, velocity);
    }

    @Override
    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, NotePosition notePosition, int velocity) {
        boolean isSelectPressed = ((PushControlSurface)this.surface).isSelectPressed();
        if (((PushControlSurface)this.surface).isShiftPressed()) {
            if (velocity > 0) {
                this.handleSequencerAreaRepeatOperator(clip, notePosition, velocity, !isSelectPressed);
            }
            return true;
        }
        if (isSelectPressed) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.SELECT);
            this.editNote(clip, notePosition, true);
            return true;
        }
        return super.handleSequencerAreaButtonCombinations(clip, notePosition, velocity);
    }
}

