/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.view;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.view.NoteRepeatSceneHelper;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.sequencer.AbstractDrum8View;

public class Drum8View
extends AbstractDrum8View<PushControlSurface, PushConfiguration> {
    public Drum8View(PushControlSurface surface, IModel model) {
        super(surface, model, true);
    }

    @Override
    public void onGridNoteLongPress(int note) {
        if (!this.isActive()) {
            return;
        }
        int index = note - 36;
        ((PushControlSurface)this.surface).getButton(ButtonID.get(ButtonID.PAD1, index)).setConsumed();
        int stepX = index % this.numColumns;
        int stepY = this.scales.getDrumOffset() + index / this.numColumns;
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), stepX, stepY);
        this.editNote(this.getClip(), notePosition, false);
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (!ButtonID.isSceneButton(buttonID) || event != ButtonEvent.DOWN) {
            return;
        }
        int index = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        if (((PushControlSurface)this.surface).isPressed(ButtonID.REPEAT)) {
            NoteRepeatSceneHelper.handleNoteRepeatSelection((PushControlSurface)this.surface, 7 - index);
            return;
        }
        super.onButton(buttonID, event, velocity);
    }

    @Override
    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, NotePosition notePosition, int row, int velocity, int accentVelocity) {
        boolean isSelectPressed = ((PushControlSurface)this.surface).isSelectPressed();
        if (((PushControlSurface)this.surface).isShiftPressed()) {
            if (velocity > 0) {
                this.handleSequencerAreaRepeatOperator(clip, notePosition, velocity, !isSelectPressed);
            }
            return true;
        }
        if (isSelectPressed) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.SELECT);
            if (velocity > 0) {
                this.editNote(clip, notePosition, true);
            }
            return true;
        }
        return super.handleSequencerAreaButtonCombinations(clip, notePosition, row, velocity, accentVelocity);
    }
}

