/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode.configuration;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.configuration.AbstractConfigurationMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.resource.ChannelType;

public class SetupMode
extends AbstractConfigurationMode {
    public SetupMode(PushControlSurface surface, IModel model) {
        super(1, "Setup", surface, model);
    }

    @Override
    public void onKnobValue(int index, int value) {
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        switch (index) {
            case 2: {
                config.changeDisplayBrightness(value);
                break;
            }
            case 3: {
                config.changeLEDBrightness(value);
                break;
            }
            case 5: {
                config.changePadSensitivity(value);
                break;
            }
            case 6: {
                config.changePadGain(value);
                break;
            }
            case 7: {
                config.changePadDynamics(value);
                break;
            }
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
        if (!isTouched || !((PushControlSurface)this.surface).isDeletePressed()) {
            return;
        }
        ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        switch (index) {
            case 2: {
                config.setDisplayBrightness(100);
                break;
            }
            case 3: {
                config.setLEDBrightness(100);
                break;
            }
            case 5: {
                config.setPadSensitivity(5);
                break;
            }
            case 6: {
                config.setPadGain(5);
                break;
            }
            case 7: {
                config.setPadDynamics(5);
                break;
            }
        }
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        int displayBrightness = config.getDisplayBrightness();
        int ledBrightness = config.getLedBrightness();
        int padSensitivity = config.getPadSensitivity();
        int padGain = config.getPadGain();
        int padDynamics = config.getPadDynamics();
        display.addOptionElement("", this.menu[0], false, "", "", false, true);
        display.addOptionElement("Brightness", this.menu[1], true, "", "", false, true);
        display.addParameterElement(this.menu[2], false, "", (ChannelType)null, null, false, "Display", displayBrightness * 1023 / 100, displayBrightness + "%", this.isKnobTouched(2), -1);
        display.addParameterElement(this.menu[3], false, "", (ChannelType)null, null, false, "LEDs", ledBrightness * 1023 / 100, ledBrightness + "%", this.isKnobTouched(3), -1);
        display.addOptionElement("        Pads", " ", false, "", "", false, true);
        display.addParameterElement(" ", false, "", (ChannelType)null, null, false, "Sensitivity", padSensitivity * 1023 / 10, Integer.toString(padSensitivity), this.isKnobTouched(5), -1);
        display.addParameterElement(" ", false, "", (ChannelType)null, null, false, "Gain", padGain * 1023 / 10, Integer.toString(padGain), this.isKnobTouched(6), -1);
        display.addParameterElement(" ", false, "", (ChannelType)null, null, false, "Dynamics", padDynamics * 1023 / 10, Integer.toString(padDynamics), this.isKnobTouched(7), -1);
    }
}

