/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.command.continuous.IPush3Encoder;
import de.mossgrabers.controller.ableton.push.controller.Push1Display;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.track.AbstractTrackMode;
import de.mossgrabers.framework.command.trigger.clip.StartClipCommand;
import de.mossgrabers.framework.command.trigger.clip.StartSceneCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IClipLauncherNavigator;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.parameterprovider.track.VolumeParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.Pair;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.ArrayList;
import java.util.Optional;

public class SessionMode
extends AbstractTrackMode
implements IPush3Encoder {
    private final PushConfiguration configuration;
    private RowDisplayMode rowDisplayMode;
    private final ISceneBank sceneBank;
    private final IClipLauncherNavigator clipLauncherNavigator;
    private final StartClipCommand<PushControlSurface, PushConfiguration> startClipCommand;
    private final StartSceneCommand<PushControlSurface, PushConfiguration> startSceneCommand;

    public SessionMode(PushControlSurface surface, IModel model) {
        super("Session", surface, model);
        this.configuration = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        this.clipLauncherNavigator = model.getClipLauncherNavigator();
        this.sceneBank = model.getSceneBank(64);
        this.startClipCommand = new StartClipCommand(model, surface);
        this.startSceneCommand = new StartSceneCommand(model, surface, -1, this.sceneBank);
        this.rowDisplayMode = this.isPushModern ? RowDisplayMode.ALL : RowDisplayMode.UPPER;
        this.setParameterProvider(new VolumeParameterProvider(model));
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
    }

    @Override
    public void onKnobValue(int index, int value) {
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (this.isPushModern) {
            if (index == 0) {
                this.rowDisplayMode = this.rowDisplayMode == RowDisplayMode.ALL || this.rowDisplayMode == RowDisplayMode.LOWER ? RowDisplayMode.UPPER : RowDisplayMode.ALL;
            } else if (index == 1) {
                this.rowDisplayMode = this.rowDisplayMode == RowDisplayMode.ALL || this.rowDisplayMode == RowDisplayMode.UPPER ? RowDisplayMode.LOWER : RowDisplayMode.ALL;
            } else if (index == 7) {
                super.onSecondRow(index, event);
            }
        } else if (index < 2) {
            this.rowDisplayMode = this.rowDisplayMode == RowDisplayMode.UPPER ? RowDisplayMode.LOWER : RowDisplayMode.UPPER;
        } else if (index == 7) {
            this.model.getTrackBank().selectParent();
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        int index = this.isButtonRow(1, buttonID);
        if (index >= 0) {
            if (index == 0) {
                return this.colorManager.getColorIndex(this.rowDisplayMode == RowDisplayMode.UPPER ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON");
            }
            if (index == 1) {
                return this.colorManager.getColorIndex(this.rowDisplayMode == RowDisplayMode.LOWER ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON");
            }
            if (index < 5) {
                return this.colorManager.getColorIndex("BUTTON_COLOR_OFF");
            }
            ITrackBank tb = this.model.getCurrentTrackBank();
            return tb.hasParent() ? 3 : 0;
        }
        return super.getButtonColor(buttonID);
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        if (this.configuration.isScenesClipViewSelected()) {
            this.updateDisplay1Scenes(display);
        } else {
            this.updateDisplay1Clips(display);
        }
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        if (this.configuration.isScenesClipViewSelected()) {
            this.updateDisplay2Scenes(display);
        } else {
            this.updateDisplay2Clips(display);
        }
    }

    @Override
    public void encoderTurn(int value) {
        boolean isLeft;
        boolean bl = isLeft = !this.model.getValueChanger().isIncrease(value);
        if (this.configuration.isScenesClipViewSelected()) {
            this.clipLauncherNavigator.navigateScenes(isLeft);
            return;
        }
        if (this.configuration.isFlipSession()) {
            this.clipLauncherNavigator.navigateTracks(isLeft);
        } else {
            this.clipLauncherNavigator.navigateClips(isLeft);
        }
    }

    @Override
    public void encoderPress(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (this.configuration.isScenesClipViewSelected()) {
            this.startSceneCommand.execute(event, 0);
        } else {
            this.startClipCommand.execute(event, 0);
        }
    }

    @Override
    public void encoderLeft(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (this.configuration.isScenesClipViewSelected()) {
            this.clipLauncherNavigator.navigateScenes(true);
            return;
        }
        if (this.configuration.isFlipSession()) {
            this.clipLauncherNavigator.navigateClips(true);
        } else {
            this.clipLauncherNavigator.navigateTracks(true);
        }
    }

    @Override
    public void encoderRight(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (this.configuration.isScenesClipViewSelected()) {
            this.clipLauncherNavigator.navigateScenes(false);
            return;
        }
        if (this.configuration.isFlipSession()) {
            this.clipLauncherNavigator.navigateClips(false);
        } else {
            this.clipLauncherNavigator.navigateTracks(false);
        }
    }

    private void updateDisplay1Scenes(ITextDisplay display) {
        int maxCols = 8;
        int maxRows = this.rowDisplayMode == RowDisplayMode.ALL ? 8 : 4;
        for (int col = 0; col < 8; ++col) {
            for (int row = 0; row < maxRows; ++row) {
                IScene scene;
                int sceneIndex = (maxRows - 1 - row) * 8 + col;
                if (this.rowDisplayMode == RowDisplayMode.LOWER) {
                    sceneIndex += 32;
                }
                if (!(scene = (IScene)this.sceneBank.getItem(sceneIndex)).doesExist()) continue;
                boolean isSel = scene.isSelected();
                String n = StringUtils.shortenAndFixASCII(scene.getName(8), isSel ? 7 : 8);
                display.setCell(row, col, (String)(isSel ? Push1Display.SELECT_ARROW + n : n));
            }
        }
    }

    private void updateDisplay1Clips(ITextDisplay display) {
        int maxRows;
        ITrackBank tb = this.model.getCurrentTrackBank();
        int numTracks = tb.getPageSize();
        int numScenes = tb.getSceneBank().getPageSize();
        boolean flipSession = this.configuration.isFlipSession();
        int maxCols = flipSession ? numScenes : numTracks;
        int n = maxRows = flipSession ? numTracks : numScenes;
        if (this.rowDisplayMode != RowDisplayMode.ALL) {
            maxRows /= 2;
        }
        for (int col = 0; col < maxCols; ++col) {
            for (int row = 0; row < maxRows; ++row) {
                ColorEx color;
                ITrack track;
                ISlot slot;
                int y;
                int x = flipSession ? row : col;
                int n2 = y = flipSession ? col : row;
                if (this.rowDisplayMode == RowDisplayMode.LOWER) {
                    if (flipSession) {
                        x += maxRows;
                    } else {
                        y += maxRows;
                    }
                }
                if (!(slot = (ISlot)(track = (ITrack)tb.getItem(x)).getSlotBank().getItem(y)).doesExist()) continue;
                Object name = slot.getName(8);
                if (track.isGroup()) {
                    if (((String)name).isEmpty()) {
                        name = "Scene " + (slot.getPosition() + 1);
                    }
                } else if (((String)name).isEmpty() && ((color = slot.getColor()).getRed() != 0.0 || color.getGreen() != 0.0 || color.getBlue() != 0.0)) {
                    name = "--------";
                }
                name = slot.isSelected() ? Push1Display.SELECT_ARROW + (String)name : (slot.isPlaying() ? ">" + (String)name : (slot.isPlayingQueued() || slot.isRecordingQueued() ? ")" + (String)name : (track.isRecArm() || slot.isRecording() ? "*" + (String)name : (slot.hasContent() ? Push1Display.RIGHT_ARROW + (String)name : Push1Display.DEGREE + (String)name))));
                display.setCell(row, col, StringUtils.shortenAndFixASCII((String)name, 8));
            }
        }
    }

    private void updateDisplay2Scenes(IGraphicDisplay display) {
        int maxCols = 8;
        int maxRows = this.rowDisplayMode == RowDisplayMode.ALL ? 8 : 4;
        ITrackBank tb = this.model.getCurrentTrackBank();
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        for (int col = 0; col < 8; ++col) {
            ArrayList<IScene> scenes = new ArrayList<IScene>(maxRows);
            for (int row = 0; row < maxRows; ++row) {
                int sceneIndex = (maxRows - 1 - row) * 8 + col;
                if (this.rowDisplayMode == RowDisplayMode.LOWER) {
                    sceneIndex += 32;
                }
                scenes.add((IScene)this.sceneBank.getItem(sceneIndex));
            }
            ITrack track = (ITrack)tb.getItem(col);
            display.addSceneListElement(scenes, track.getType(), track.getName(), track.getColor(), track.isSelected(), track.isActivated(), cursorTrack.isPinned());
        }
    }

    private void updateDisplay2Clips(IGraphicDisplay display) {
        int maxRows;
        ITrackBank tb = this.model.getCurrentTrackBank();
        int numTracks = tb.getPageSize();
        int numScenes = tb.getSceneBank().getPageSize();
        boolean flipSession = this.configuration.isFlipSession();
        int maxCols = flipSession ? numScenes : numTracks;
        int n = maxRows = flipSession ? numTracks : numScenes;
        if (this.rowDisplayMode != RowDisplayMode.ALL) {
            maxRows /= 2;
        }
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        for (int col = 0; col < maxCols; ++col) {
            ArrayList<Pair<ITrack, ISlot>> slots = new ArrayList<Pair<ITrack, ISlot>>(maxRows);
            for (int row = 0; row < maxRows; ++row) {
                int y;
                int x = flipSession ? row : col;
                int n2 = y = flipSession ? col : row;
                if (this.rowDisplayMode == RowDisplayMode.LOWER) {
                    if (flipSession) {
                        x += maxRows;
                    } else {
                        y += maxRows;
                    }
                }
                ITrack track = (ITrack)tb.getItem(x);
                slots.add(new Pair<ITrack, ISlot>(track, (ISlot)track.getSlotBank().getItem(y)));
            }
            ITrack track = (ITrack)tb.getItem(col);
            display.addSlotListElement(slots, track.getType(), track.getName(), track.getColor(), track.isSelected(), track.isActivated(), cursorTrack.isPinned());
        }
    }

    @Override
    public void arrowCenter(ButtonEvent event) {
        Optional selectedScene = this.model.getSceneBank().getSelectedItem();
        if (selectedScene.isPresent()) {
            ((IScene)selectedScene.get()).launch(event == ButtonEvent.DOWN, true);
        }
    }

    private static enum RowDisplayMode {
        ALL,
        UPPER,
        LOWER;

    }
}

