/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode;

import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.IStepInfo;
import de.mossgrabers.framework.daw.clip.NoteOccurrenceType;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.daw.data.empty.EmptyParameter;
import de.mossgrabers.framework.mode.INoteEditor;
import de.mossgrabers.framework.mode.INoteEditorMode;
import de.mossgrabers.framework.mode.NoteEditor;
import de.mossgrabers.framework.parameter.NoteAttribute;
import de.mossgrabers.framework.parameter.NoteParameter;
import de.mossgrabers.framework.parameterprovider.IParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class NoteMode
extends BaseMode<IItem>
implements INoteEditorMode {
    private static final String OFF = "  Off";
    private static final String ON = "   On";
    private static final String[] MENU = new String[]{"Common", "Expressions", "Repeat", " ", " ", " ", " ", "Recurr. Pattern"};
    private static final String[] RECURRENCE_PRESETS = new String[]{"First", "Not first", " ", "Last", "Not last", " ", "Odd", "Even"};
    private final IHost host;
    private Page page = Page.NOTE;
    private final NoteEditor noteEditor = new NoteEditor();
    private final Map<Page, IParameterProvider> pageParamProviders = new EnumMap<Page, IParameterProvider>(Page.class);

    public NoteMode(PushControlSurface surface, IModel model) {
        super("Note", surface, model);
        this.host = this.model.getHost();
        IValueChanger valueChanger = model.getValueChanger();
        NoteParameter durationParameter = new NoteParameter(NoteAttribute.DURATION, null, model, this.noteEditor, valueChanger);
        NoteParameter muteParameter = new NoteParameter(NoteAttribute.MUTE, null, model, this.noteEditor, valueChanger);
        this.pageParamProviders.put(Page.NOTE, new FixedParameterProvider(durationParameter, muteParameter, new NoteParameter(NoteAttribute.VELOCITY, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.VELOCITY_SPREAD, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.RELEASE_VELOCITY, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.CHANCE, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.OCCURRENCE, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.RECURRENCE_LENGTH, null, model, this.noteEditor, valueChanger)));
        this.pageParamProviders.put(Page.EXPRESSIONS, new FixedParameterProvider(durationParameter, muteParameter, EmptyParameter.INSTANCE, new NoteParameter(NoteAttribute.GAIN, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.PANORAMA, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.TRANSPOSE, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.TIMBRE, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.PRESSURE, null, model, this.noteEditor, valueChanger)));
        this.pageParamProviders.put(Page.REPEAT, new FixedParameterProvider(durationParameter, muteParameter, EmptyParameter.INSTANCE, new NoteParameter(NoteAttribute.REPEAT, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.REPEAT_CURVE, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.REPEAT_VELOCITY_CURVE, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.REPEAT_VELOCITY_END, null, model, this.noteEditor, valueChanger), EmptyParameter.INSTANCE));
        this.pageParamProviders.put(Page.RECCURRENCE_PATTERN, new FixedParameterProvider(EmptyParameter.INSTANCE, EmptyParameter.INSTANCE, EmptyParameter.INSTANCE, EmptyParameter.INSTANCE, EmptyParameter.INSTANCE, EmptyParameter.INSTANCE, EmptyParameter.INSTANCE, new NoteParameter(NoteAttribute.RECURRENCE_LENGTH, null, model, this.noteEditor, valueChanger)));
        this.rebind();
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        INoteClip clip = this.noteEditor.getClip();
        List<NotePosition> notes = this.noteEditor.getNotes();
        for (NotePosition notePosition : notes) {
            IStepInfo stepInfo = clip.getStep(notePosition);
            block0 : switch (this.page.ordinal()) {
                case 0: {
                    switch (index) {
                        case 5: {
                            if (!this.host.supports(NoteAttribute.CHANCE)) break block0;
                            clip.updateStepIsChanceEnabled(notePosition, !stepInfo.isChanceEnabled());
                            break block0;
                        }
                        case 6: {
                            if (!this.host.supports(NoteAttribute.OCCURRENCE)) break block0;
                            clip.updateStepIsOccurrenceEnabled(notePosition, !stepInfo.isOccurrenceEnabled());
                            break block0;
                        }
                        case 7: {
                            if (!this.host.supports(NoteAttribute.RECURRENCE_LENGTH)) break block0;
                            clip.updateStepIsRecurrenceEnabled(notePosition, !stepInfo.isRecurrenceEnabled());
                            break block0;
                        }
                    }
                    return;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (index != 3 || !this.host.supports(NoteAttribute.REPEAT)) break;
                    clip.updateStepIsRepeatEnabled(notePosition, !stepInfo.isRepeatEnabled());
                    break;
                }
                case 1: {
                    if (!this.host.supports(NoteAttribute.RECURRENCE_LENGTH)) break;
                    if (((PushControlSurface)this.surface).isShiftPressed()) {
                        switch (index) {
                            case 0: {
                                clip.updateStepRecurrenceMask(notePosition, 1);
                                break block0;
                            }
                            case 1: {
                                clip.updateStepRecurrenceMask(notePosition, 254);
                                break block0;
                            }
                            case 3: {
                                int lastRecurrence = 1 << stepInfo.getRecurrenceLength() - 1;
                                clip.updateStepRecurrenceMask(notePosition, lastRecurrence);
                                break block0;
                            }
                            case 4: {
                                int notLastRecurrence = (1 << stepInfo.getRecurrenceLength() - 1) - 1;
                                clip.updateStepRecurrenceMask(notePosition, notLastRecurrence);
                                break block0;
                            }
                            case 6: {
                                clip.updateStepRecurrenceMask(notePosition, 85);
                                break block0;
                            }
                            case 7: {
                                clip.updateStepRecurrenceMask(notePosition, 170);
                                break block0;
                            }
                        }
                        break;
                    }
                    clip.updateStepRecurrenceMaskToggleBit(notePosition, index);
                }
            }
        }
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        switch (index) {
            case 0: {
                this.page = Page.NOTE;
                break;
            }
            case 1: {
                if (!this.host.supports(NoteAttribute.TIMBRE)) break;
                this.page = Page.EXPRESSIONS;
                break;
            }
            case 2: {
                if (!this.host.supports(NoteAttribute.REPEAT)) break;
                this.page = Page.REPEAT;
                break;
            }
            case 7: {
                if (!this.host.supports(NoteAttribute.RECURRENCE_LENGTH)) break;
                this.page = Page.RECCURRENCE_PATTERN;
                break;
            }
        }
        this.rebind();
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        List<NotePosition> notes = this.noteEditor.getNotes();
        if (notes.isEmpty()) {
            return;
        }
        if (isTouched && ((PushControlSurface)this.surface).isDeletePressed()) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
            this.defaultParameterProvider.get(index).resetValue();
            return;
        }
        INoteClip clip = this.noteEditor.getClip();
        if (isTouched) {
            clip.startEdit(notes);
        } else {
            clip.stopEdit();
        }
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        List<NotePosition> notes = this.noteEditor.getNotes();
        if (notes.isEmpty()) {
            display.setRow(1, "                     Please selecta note...                         ");
            return;
        }
        NotePosition notePosition = notes.get(0);
        INoteClip clip = this.noteEditor.getClip();
        IStepInfo stepInfo = clip.getStep(notePosition);
        if (this.page != Page.RECCURRENCE_PATTERN) {
            int size;
            display.setCell(0, 0, "Length").setCell(1, 0, this.formatLength(stepInfo.getDuration()));
            if (stepInfo.isMuted()) {
                display.setCell(2, 1, " MUTED");
            }
            boolean isOneNote = (size = notes.size()) == 1;
            display.setCell(3, 0, isOneNote ? "Step: " + (notePosition.getStep() + 1) : "Notes: " + size);
            display.setCell(3, 1, isOneNote ? Scales.formatNoteAndOctave(notePosition.getNote(), -3) : "*");
        }
        IValueChanger valueChanger = this.model.getValueChanger();
        switch (this.page.ordinal()) {
            case 0: {
                display.setCell(0, 1, " COMMON:");
                double noteVelocity = stepInfo.getVelocity();
                int parameterValue = valueChanger.fromNormalizedValue(noteVelocity);
                display.setCell(0, 2, "Velocity");
                display.setCell(1, 2, StringUtils.formatPercentage(noteVelocity));
                display.setCell(2, 2, parameterValue, Format.FORMAT_VALUE);
                if (this.host.supports(NoteAttribute.VELOCITY_SPREAD)) {
                    double noteVelocitySpread = stepInfo.getVelocitySpread();
                    int parameterSpreadValue = valueChanger.fromNormalizedValue(noteVelocitySpread);
                    display.setCell(0, 3, "V-Spread");
                    display.setCell(1, 3, StringUtils.formatPercentage(noteVelocitySpread));
                    display.setCell(2, 3, parameterSpreadValue, Format.FORMAT_VALUE);
                }
                if (this.host.supports(NoteAttribute.RELEASE_VELOCITY)) {
                    double noteReleaseVelocity = stepInfo.getReleaseVelocity();
                    int parameterReleaseValue = valueChanger.fromNormalizedValue(noteReleaseVelocity);
                    display.setCell(0, 4, "R-Velcty");
                    display.setCell(1, 4, StringUtils.formatPercentage(noteReleaseVelocity));
                    display.setCell(2, 4, parameterReleaseValue, Format.FORMAT_VALUE);
                }
                if (this.host.supports(NoteAttribute.CHANCE)) {
                    double chance = stepInfo.getChance();
                    int chanceValue = valueChanger.fromNormalizedValue(chance);
                    display.setCell(0, 5, "Chance");
                    display.setCell(1, 5, StringUtils.formatPercentage(chance));
                    display.setCell(2, 5, chanceValue, Format.FORMAT_VALUE);
                    display.setCell(3, 5, stepInfo.isChanceEnabled() ? ON : OFF);
                }
                if (this.host.supports(NoteAttribute.OCCURRENCE)) {
                    NoteOccurrenceType occurrence = stepInfo.getOccurrence();
                    display.setCell(0, 6, "Occurnce");
                    display.setCell(1, 6, StringUtils.optimizeName(occurrence.getName(), 8));
                    display.setCell(3, 6, stepInfo.isOccurrenceEnabled() ? ON : OFF);
                }
                if (!this.host.supports(NoteAttribute.RECURRENCE_LENGTH)) break;
                int recurrence = stepInfo.getRecurrenceLength();
                String recurrenceStr = recurrence < 2 ? "Off" : Integer.toString(recurrence);
                int recurrenceVal = (recurrence - 1) * (this.model.getValueChanger().getUpperBound() - 1) / 7;
                display.setCell(0, 7, "Recurnce");
                display.setCell(1, 7, recurrenceStr);
                display.setCell(2, 7, recurrenceVal, Format.FORMAT_VALUE);
                display.setCell(3, 7, stepInfo.isRecurrenceEnabled() ? ON : OFF);
                break;
            }
            case 2: {
                if (!this.host.supports(NoteAttribute.TIMBRE)) break;
                display.setCell(0, 2, "EXPRESS:");
                double noteGain = stepInfo.getGain();
                int parameterGainValue = Math.min(1023, valueChanger.fromNormalizedValue(noteGain));
                display.setCell(0, 3, "Gain").setCell(1, 3, StringUtils.formatPercentage(noteGain)).setCell(2, 3, parameterGainValue, Format.FORMAT_VALUE);
                double notePan = stepInfo.getPan();
                int parameterPanValue = valueChanger.fromNormalizedValue((notePan + 1.0) / 2.0);
                display.setCell(0, 4, "Pan").setCell(1, 4, StringUtils.formatPercentage(notePan)).setCell(2, 4, parameterPanValue, Format.FORMAT_PAN);
                double noteTranspose = stepInfo.getTranspose();
                double transposeRange = clip.getStepTransposeRange();
                int parameterTransposeValue = valueChanger.fromNormalizedValue((noteTranspose + transposeRange) / (2.0 * transposeRange));
                display.setCell(0, 5, "Pitch").setCell(1, 5, String.format("%.1f", noteTranspose)).setCell(2, 5, parameterTransposeValue, Format.FORMAT_PAN);
                double noteTimbre = stepInfo.getTimbre();
                int parameterTimbreValue = valueChanger.fromNormalizedValue((noteTimbre + 1.0) / 2.0);
                display.setCell(0, 6, "Timbre").setCell(1, 6, StringUtils.formatPercentage(noteTimbre)).setCell(2, 6, parameterTimbreValue, Format.FORMAT_VALUE);
                double notePressure = stepInfo.getPressure();
                int parameterPressureValue = valueChanger.fromNormalizedValue(notePressure);
                display.setCell(0, 7, "Pressure").setCell(1, 7, StringUtils.formatPercentage(notePressure)).setCell(2, 7, parameterPressureValue, Format.FORMAT_VALUE);
                break;
            }
            case 3: {
                display.setCell(0, 2, "REPEAT:");
                int repeatCount = stepInfo.getRepeatCount();
                String repeatCountValue = stepInfo.getFormattedRepeatCount();
                int rc = (repeatCount + 127) * (this.model.getValueChanger().getUpperBound() - 1) / 254;
                display.setCell(0, 3, "Count");
                display.setCell(1, 3, repeatCountValue);
                display.setCell(2, 3, rc, Format.FORMAT_VALUE);
                display.setCell(3, 3, stepInfo.isRepeatEnabled() ? ON : OFF);
                double repeatCurve = stepInfo.getRepeatCurve();
                int repeatCurveValue = valueChanger.fromNormalizedValue((repeatCurve + 1.0) / 2.0);
                display.setCell(0, 4, "Curve");
                display.setCell(1, 4, StringUtils.formatPercentage(repeatCurve));
                display.setCell(2, 4, repeatCurveValue, Format.FORMAT_VALUE);
                double repeatVelocityCurve = stepInfo.getRepeatVelocityCurve();
                int repeatVelocityCurveValue = valueChanger.fromNormalizedValue((repeatVelocityCurve + 1.0) / 2.0);
                display.setCell(0, 5, "Vel-Crve");
                display.setCell(1, 5, StringUtils.formatPercentage(repeatVelocityCurve));
                display.setCell(2, 5, repeatVelocityCurveValue, Format.FORMAT_VALUE);
                double repeatVelocityEnd = stepInfo.getRepeatVelocityEnd();
                int repeatVelocityEndValue = valueChanger.fromNormalizedValue((repeatVelocityEnd + 1.0) / 2.0);
                display.setCell(0, 6, "Vel. End");
                display.setCell(1, 6, StringUtils.formatPercentage(repeatVelocityEnd));
                display.setCell(2, 6, repeatVelocityEndValue, Format.FORMAT_VALUE);
                break;
            }
            case 1: {
                display.setBlock(0, 1, "       Recurrence");
                display.setBlock(0, 2, "Pattern");
                int recurrenceLength = stepInfo.getRecurrenceLength();
                int mask = stepInfo.getRecurrenceMask();
                for (int i = 0; i < 8; ++i) {
                    String label = "   -";
                    if (((PushControlSurface)this.surface).isShiftPressed()) {
                        label = RECURRENCE_PRESETS[i];
                    } else {
                        boolean isOn;
                        boolean bl = isOn = (mask & 1 << i) > 0;
                        if (i < recurrenceLength) {
                            String string = label = isOn ? ON : OFF;
                        }
                    }
                    if (i == 7) {
                        int recurrence = stepInfo.getRecurrenceLength();
                        String recurrenceStr = recurrence < 2 ? "Off" : Integer.toString(recurrence);
                        int recurrenceVal = (recurrence - 1) * (this.model.getValueChanger().getUpperBound() - 1) / 7;
                        display.setCell(0, 7, "Recurnce");
                        display.setCell(1, 7, recurrenceStr);
                        display.setCell(2, 7, recurrenceVal, Format.FORMAT_VALUE);
                    }
                    display.setCell(3, i, label);
                }
                break;
            }
        }
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        List<NotePosition> notes = this.noteEditor.getNotes();
        if (notes.isEmpty()) {
            for (int i = 0; i < 8; ++i) {
                display.addOptionElement(i == 2 ? "Please select a note to edit..." : "", "", false, "", "", false, true);
            }
            return;
        }
        NotePosition notePosition = notes.get(0);
        INoteClip clip = this.noteEditor.getClip();
        IStepInfo stepInfo = clip.getStep(notePosition);
        IValueChanger valueChanger = this.model.getValueChanger();
        if (this.page != Page.RECCURRENCE_PATTERN) {
            String bottomMenu;
            int size = notes.size();
            boolean isOneNote = size == 1;
            String stepBottomMenu = isOneNote ? "Step: " + (notePosition.getStep() + 1) : "Notes: " + size;
            display.addParameterElementWithPlainMenu(MENU[0], this.page == Page.NOTE, stepBottomMenu, null, false, "Length", -1, this.formatLength(stepInfo.getDuration()), this.isKnobTouched(0), -1);
            boolean hasExpressions = this.host.supports(NoteAttribute.TIMBRE);
            String topMenu = hasExpressions ? MENU[1] : " ";
            boolean isTopMenuOn = hasExpressions && this.page == Page.EXPRESSIONS;
            String string = bottomMenu = isOneNote ? Scales.formatNoteAndOctave(notePosition.getNote(), -3) : "*";
            if (this.host.supports(NoteAttribute.MUTE)) {
                int value = stepInfo.isMuted() ? valueChanger.getUpperBound() : 0;
                display.addParameterElementWithPlainMenu(topMenu, isTopMenuOn, bottomMenu, null, false, "Is Muted?", value, stepInfo.isMuted() ? "Yes" : "No", this.isKnobTouched(1), value);
            } else {
                display.addParameterElementWithPlainMenu(topMenu, isTopMenuOn, bottomMenu, null, false, null, -1, null, false, -1);
            }
        }
        switch (this.page.ordinal()) {
            case 0: {
                double noteVelocity = stepInfo.getVelocity();
                int parameterValue = valueChanger.fromNormalizedValue(noteVelocity);
                display.addParameterElementWithPlainMenu(this.host.supports(NoteAttribute.REPEAT) ? MENU[2] : " ", false, null, null, false, "Velocity", parameterValue, StringUtils.formatPercentage(noteVelocity), this.isKnobTouched(2), parameterValue);
                if (this.host.supports(NoteAttribute.VELOCITY_SPREAD)) {
                    double noteVelocitySpread = stepInfo.getVelocitySpread();
                    int parameterSpreadValue = valueChanger.fromNormalizedValue(noteVelocitySpread);
                    display.addParameterElementWithPlainMenu(MENU[3], false, null, null, false, "Vel-Spread", parameterSpreadValue, StringUtils.formatPercentage(noteVelocitySpread), this.isKnobTouched(3), parameterSpreadValue);
                } else {
                    display.addEmptyElement(true);
                }
                if (this.host.supports(NoteAttribute.RELEASE_VELOCITY)) {
                    double noteReleaseVelocity = stepInfo.getReleaseVelocity();
                    int parameterReleaseValue = valueChanger.fromNormalizedValue(noteReleaseVelocity);
                    display.addParameterElementWithPlainMenu(MENU[4], false, null, null, false, "R-Velocity", parameterReleaseValue, StringUtils.formatPercentage(noteReleaseVelocity), this.isKnobTouched(4), parameterReleaseValue);
                } else {
                    display.addEmptyElement(true);
                }
                if (this.host.supports(NoteAttribute.CHANCE)) {
                    double chance = stepInfo.getChance();
                    int chanceValue = valueChanger.fromNormalizedValue(chance);
                    display.addParameterElementWithPlainMenu(MENU[5], false, stepInfo.isChanceEnabled() ? "On" : "Off", null, false, "Chance", chanceValue, StringUtils.formatPercentage(chance), this.isKnobTouched(5), chanceValue);
                } else {
                    display.addEmptyElement(true);
                }
                if (this.host.supports(NoteAttribute.OCCURRENCE)) {
                    NoteOccurrenceType occurrence = stepInfo.getOccurrence();
                    display.addParameterElementWithPlainMenu(MENU[6], false, stepInfo.isOccurrenceEnabled() ? "On" : "Off", null, false, "Occurrence", -1, StringUtils.optimizeName(occurrence.getName(), 9), this.isKnobTouched(6), -1);
                } else {
                    display.addEmptyElement(true);
                }
                if (this.host.supports(NoteAttribute.RECURRENCE_LENGTH)) {
                    int recurrence = stepInfo.getRecurrenceLength();
                    String recurrenceStr = recurrence < 2 ? "Off" : Integer.toString(recurrence);
                    int recurrenceVal = (recurrence - 1) * (this.model.getValueChanger().getUpperBound() - 1) / 7;
                    display.addParameterElementWithPlainMenu(MENU[7], false, stepInfo.isRecurrenceEnabled() ? "On" : "Off", null, false, "Recurrence", recurrenceVal, recurrenceStr, this.isKnobTouched(7), recurrenceVal);
                    break;
                }
                display.addEmptyElement(true);
                break;
            }
            case 2: {
                display.addParameterElementWithPlainMenu(MENU[2], false, null, null, false, null, -1, null, false, -1);
                double noteGain = stepInfo.getGain();
                int parameterGainValue = Math.min(1023, valueChanger.fromNormalizedValue(noteGain));
                display.addParameterElementWithPlainMenu(MENU[3], false, null, null, false, "Gain", parameterGainValue, StringUtils.formatPercentage(noteGain), this.isKnobTouched(3), parameterGainValue);
                double notePan = stepInfo.getPan();
                int parameterPanValue = valueChanger.fromNormalizedValue((notePan + 1.0) / 2.0);
                display.addParameterElementWithPlainMenu(MENU[4], false, null, null, false, "Pan", parameterPanValue, StringUtils.formatPercentage(notePan), this.isKnobTouched(4), parameterPanValue);
                double noteTranspose = stepInfo.getTranspose();
                double transposeRange = clip.getStepTransposeRange();
                int parameterTransposeValue = valueChanger.fromNormalizedValue((noteTranspose + transposeRange) / (2.0 * transposeRange));
                display.addParameterElementWithPlainMenu(MENU[5], false, null, null, false, "Pitch", parameterTransposeValue, String.format("%.1f", noteTranspose), this.isKnobTouched(5), parameterTransposeValue);
                double noteTimbre = stepInfo.getTimbre();
                int parameterTimbreValue = valueChanger.fromNormalizedValue((noteTimbre + 1.0) / 2.0);
                display.addParameterElementWithPlainMenu(MENU[6], false, null, null, false, "Timbre", parameterTimbreValue, StringUtils.formatPercentage(noteTimbre), this.isKnobTouched(6), parameterTimbreValue);
                double notePressure = stepInfo.getPressure();
                int parameterPressureValue = valueChanger.fromNormalizedValue(notePressure);
                display.addParameterElementWithPlainMenu(MENU[7], this.page == Page.RECCURRENCE_PATTERN, null, null, false, "Pressure", parameterPressureValue, StringUtils.formatPercentage(notePressure), this.isKnobTouched(7), parameterPressureValue);
                break;
            }
            case 3: {
                display.addParameterElementWithPlainMenu(MENU[2], true, null, null, false, null, -1, null, false, -1);
                int repeatCount = stepInfo.getRepeatCount();
                String repeatCountValue = stepInfo.getFormattedRepeatCount();
                int rc = (repeatCount + 127) * (this.model.getValueChanger().getUpperBound() - 1) / 254;
                display.addParameterElementWithPlainMenu(MENU[3], false, stepInfo.isRepeatEnabled() ? "On" : "Off", null, false, "Count", rc, repeatCountValue, this.isKnobTouched(3), rc);
                double repeatCurve = stepInfo.getRepeatCurve();
                int repeatCurveValue = valueChanger.fromNormalizedValue((repeatCurve + 1.0) / 2.0);
                display.addParameterElementWithPlainMenu(MENU[4], false, null, null, false, "Curve", repeatCurveValue, StringUtils.formatPercentage(repeatCurve), this.isKnobTouched(4), repeatCurveValue);
                double repeatVelocityCurve = stepInfo.getRepeatVelocityCurve();
                int repeatVelocityCurveValue = valueChanger.fromNormalizedValue((repeatVelocityCurve + 1.0) / 2.0);
                display.addParameterElementWithPlainMenu(MENU[5], false, null, null, false, "Vel. Curve", repeatVelocityCurveValue, StringUtils.formatPercentage(repeatVelocityCurve), this.isKnobTouched(5), repeatVelocityCurveValue);
                double repeatVelocityEnd = stepInfo.getRepeatVelocityEnd();
                int repeatVelocityEndValue = valueChanger.fromNormalizedValue((repeatVelocityEnd + 1.0) / 2.0);
                display.addParameterElementWithPlainMenu(MENU[6], false, null, null, false, "Vel. End", repeatVelocityEndValue, StringUtils.formatPercentage(repeatVelocityEnd), this.isKnobTouched(6), repeatVelocityEndValue);
                display.addParameterElementWithPlainMenu(MENU[7], false, null, null, false, null, -1, null, false, -1);
                break;
            }
            case 1: {
                int recurrenceLength = stepInfo.getRecurrenceLength();
                int mask = stepInfo.getRecurrenceMask();
                for (int i = 0; i < 8; ++i) {
                    ColorEx color = ColorEx.BLACK;
                    String label = "-";
                    if (((PushControlSurface)this.surface).isShiftPressed()) {
                        color = RECURRENCE_PRESETS[i].isBlank() ? ColorEx.BLACK : ColorEx.GRAY;
                        label = RECURRENCE_PRESETS[i];
                    } else {
                        boolean isOn;
                        boolean bl = isOn = (mask & 1 << i) > 0;
                        if (i < recurrenceLength) {
                            color = isOn ? ColorEx.ORANGE : null;
                            String string = label = isOn ? "On" : "Off";
                        }
                    }
                    if (i == 7) {
                        int recurrence = stepInfo.getRecurrenceLength();
                        String recurrenceStr = recurrence < 2 ? "Off" : Integer.toString(recurrence);
                        int recurrenceVal = (recurrence - 1) * (this.model.getValueChanger().getUpperBound() - 1) / 7;
                        display.addParameterElementWithPlainMenu(MENU[i], i == 7, label, color, false, "Recurrence", recurrenceVal, recurrenceStr, this.isKnobTouched(7), recurrenceVal);
                        continue;
                    }
                    display.addParameterElementWithPlainMenu(MENU[i], i == 7, label, color, false, null, -1, null, false, -1);
                }
                break;
            }
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        List<NotePosition> notes = this.noteEditor.getNotes();
        if (notes.isEmpty()) {
            return this.colorManager.getColorIndex("PUSH_BLACK");
        }
        INoteClip clip = this.noteEditor.getClip();
        for (NotePosition notePosition : notes) {
            IStepInfo stepInfo = clip.getStep(notePosition);
            int index = this.isButtonRow(0, buttonID);
            if (index >= 0) {
                switch (this.page.ordinal()) {
                    case 0: {
                        if (index == 5 && this.host.supports(NoteAttribute.CHANCE)) {
                            return this.colorManager.getColorIndex(stepInfo.isChanceEnabled() ? "PUSH_ORANGE_HI" : "PUSH_ORANGE_LO");
                        }
                        if (index == 6 && this.host.supports(NoteAttribute.OCCURRENCE)) {
                            return this.colorManager.getColorIndex(stepInfo.isOccurrenceEnabled() ? "PUSH_ORANGE_HI" : "PUSH_ORANGE_LO");
                        }
                        if (index != 7 || !this.host.supports(NoteAttribute.RECURRENCE_LENGTH)) break;
                        return this.colorManager.getColorIndex(stepInfo.isRecurrenceEnabled() ? "PUSH_ORANGE_HI" : "PUSH_ORANGE_LO");
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        if (index != 3) break;
                        return this.colorManager.getColorIndex(stepInfo.isRepeatEnabled() ? "PUSH_ORANGE_HI" : "PUSH_ORANGE_LO");
                    }
                    case 1: {
                        if (((PushControlSurface)this.surface).isShiftPressed()) {
                            return this.colorManager.getColorIndex(RECURRENCE_PRESETS[index].isBlank() ? "PUSH_BLACK" : "PUSH_GREEN_LO");
                        }
                        int recurrenceLength = stepInfo.getRecurrenceLength();
                        int mask = stepInfo.getRecurrenceMask();
                        boolean isOn = (mask & 1 << index) > 0;
                        String color = "PUSH_BLACK";
                        if (index < recurrenceLength) {
                            color = isOn ? "PUSH_ORANGE_HI" : "PUSH_ORANGE_LO";
                        }
                        return this.colorManager.getColorIndex(color);
                    }
                }
                return this.colorManager.getColorIndex("PUSH_BLACK");
            }
            index = this.isButtonRow(1, buttonID);
            if (index < 0) continue;
            switch (this.page.ordinal()) {
                case 0: {
                    if (index != 0) break;
                    return this.colorManager.getColorIndex("PUSH_GREEN_2");
                }
                case 2: {
                    if (index != 1) break;
                    return this.colorManager.getColorIndex("PUSH_GREEN_2");
                }
                case 3: {
                    if (index != 2) break;
                    return this.colorManager.getColorIndex("PUSH_GREEN_2");
                }
                case 1: {
                    if (index != 7) break;
                    return this.colorManager.getColorIndex("PUSH_GREEN_2");
                }
            }
            if (index == 0 || index == 1 && this.host.supports(NoteAttribute.TIMBRE)) {
                return this.colorManager.getColorIndex("PUSH_GREY_LO_2");
            }
            if (index == 2 && this.host.supports(NoteAttribute.REPEAT) || index == 7 && this.host.supports(NoteAttribute.RECURRENCE_LENGTH)) {
                return this.colorManager.getColorIndex("PUSH_GREY_LO_2");
            }
            return this.colorManager.getColorIndex("PUSH_BLACK_2");
        }
        return this.colorManager.getColorIndex("PUSH_BLACK");
    }

    private String formatLength(double duration) {
        return StringUtils.formatMeasures(this.model.getTransport().getQuartersPerMeasure(), duration, 0, true);
    }

    @Override
    public INoteEditor getNoteEditor() {
        return this.noteEditor;
    }

    private void rebind() {
        this.setParameterProvider(this.pageParamProviders.get((Object)this.page));
        this.bindControls();
    }

    private static enum Page {
        NOTE,
        RECCURRENCE_PATTERN,
        EXPRESSIONS,
        REPEAT;

    }
}

