/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode;

import de.mossgrabers.controller.ableton.push.controller.Push1Display;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IMarker;
import de.mossgrabers.framework.daw.data.bank.IMarkerBank;
import de.mossgrabers.framework.parameterprovider.track.VolumeParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;

public class MarkerMode
extends BaseMode<IMarker> {
    private static final String[] EDIT_MENU = new String[]{"Add Marker", "", "", "", "", "", "Select", "Launch"};
    private boolean actionModeLaunch = true;

    public MarkerMode(PushControlSurface surface, IModel model) {
        super("Marker", surface, model, model.getMarkerBank());
        this.setParameterProvider(new VolumeParameterProvider(model));
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        IMarker marker = (IMarker)this.bank.getItem(index);
        if (!marker.doesExist()) {
            return;
        }
        if (this.isButtonCombination(ButtonID.DELETE)) {
            marker.removeMarker();
            return;
        }
        if (this.actionModeLaunch) {
            marker.launch(true);
        } else {
            marker.select();
        }
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        switch (index) {
            case 0: {
                ((IMarkerBank)this.bank).addMarker();
                break;
            }
            case 6: {
                this.actionModeLaunch = false;
                break;
            }
            case 7: {
                this.actionModeLaunch = true;
                break;
            }
        }
    }

    @Override
    public void selectNextItem() {
        this.bank.selectNextPage();
    }

    @Override
    public void selectPreviousItem() {
        this.bank.selectPreviousPage();
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        display.setCell(2, 0, "Markers:");
        for (int i = 0; i < 8; ++i) {
            IMarker marker;
            if (i == 0) {
                display.setBlock(0, i, EDIT_MENU[i]);
            }
            if (i == 6) {
                display.setCell(0, i, (!this.actionModeLaunch ? Push1Display.SELECT_ARROW : "") + EDIT_MENU[i]);
            }
            if (i == 7) {
                display.setCell(0, i, (this.actionModeLaunch ? Push1Display.SELECT_ARROW : "") + EDIT_MENU[i]);
            }
            if (!(marker = (IMarker)this.bank.getItem(i)).doesExist()) continue;
            display.setCell(3, i, StringUtils.shortenAndFixASCII(MarkerMode.getMarkerName(marker), 8));
        }
        display.setCell(0, 5, "Action:");
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        for (int i = 0; i < 8; ++i) {
            IMarker marker = (IMarker)this.bank.getItem(i);
            String menuTopName = EDIT_MENU[i];
            String headerBottomName = i == 0 ? "Markers" : "";
            String headerTopName = i == 6 ? "Action" : "";
            boolean isMenuTopSelected = i == 6 && !this.actionModeLaunch || i == 7 && this.actionModeLaunch;
            String menuBottomName = StringUtils.shortenAndFixASCII(MarkerMode.getMarkerName(marker), 12);
            display.addOptionElement(headerTopName, menuTopName, isMenuTopSelected, null, headerBottomName, menuBottomName, false, marker.getColor(), false);
        }
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        int index = this.isButtonRow(0, buttonID);
        if (index >= 0) {
            return ((IMarker)this.bank.getItem(index)).doesExist() ? "BUTTON_COLOR_ON" : "BUTTON_COLOR_OFF";
        }
        index = this.isButtonRow(1, buttonID);
        if (index >= 0) {
            return EDIT_MENU[index].isEmpty() ? "BUTTON_COLOR_OFF" : "BUTTON_COLOR2_ON";
        }
        return "BUTTON_COLOR_OFF";
    }

    private static String getMarkerName(IMarker marker) {
        if (!marker.doesExist()) {
            return "";
        }
        String name = marker.getName();
        if (name.isBlank()) {
            return "Mark " + marker.getPosition();
        }
        return name;
    }
}

