/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.controller;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.framework.controller.display.AbstractTextDisplay;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.Pair;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Push1Display
extends AbstractTextDisplay {
    public static final String BARS_NON = Character.toString('\u0006');
    public static final String BARS_ONE = Character.toString('\u0003');
    public static final String BARS_TWO = Character.toString('\u0005');
    public static final String BARS_ONE_L = Character.toString('\u0004');
    private static final String NON_4 = BARS_NON + BARS_NON + BARS_NON + BARS_NON;
    public static final String SELECT_ARROW = Character.toString('\u007f');
    public static final String DEGREE = Character.toString('\t');
    public static final String RIGHT_ARROW = Character.toString('\u001e');
    public static final String FOLDER = Character.toString('\u0007');
    public static final String THREE_ROWS = Character.toString('\u0002');
    public static final String DIVISION = Character.toString('\u0018');
    private static final String[] SYSEX_MESSAGE = new String[]{"F0 47 7F 15 18 00 45 00 ", "F0 47 7F 15 19 00 45 00 ", "F0 47 7F 15 1A 00 45 00 ", "F0 47 7F 15 1B 00 45 00 "};
    private final int maxParameterValue;

    public Push1Display(IHost host, int maxParameterValue, IMidiOutput output, PushConfiguration configuration) {
        super(host, output, 4, 8, 68);
        this.maxParameterValue = maxParameterValue;
    }

    @Override
    public void shutdown() {
        this.clear().setBlock(1, 1, "     Please start").setBlock(1, 2, this.host.getName() + " to play...").allDone().flush();
    }

    @Override
    public ITextDisplay clearCell(int row, int column) {
        this.cells[row * this.noOfCells + column] = column % 2 == 0 ? "         " : "        ";
        return this;
    }

    @Override
    public ITextDisplay setBlock(int row, int block, String value) {
        int cell = 2 * block;
        if (value.length() > 9) {
            this.cells[row * 8 + cell] = value.substring(0, 9);
            this.cells[row * 8 + cell + 1] = StringUtils.pad(value.substring(9), 8, ' ');
        } else {
            this.cells[row * 8 + cell] = StringUtils.pad(value, 9, ' ');
            this.clearCell(row, cell + 1);
        }
        return this;
    }

    @Override
    public ITextDisplay setCell(int row, int cell, int value, Format format) {
        return this.setCell(row, cell, Push1Display.formatStr(value, format, this.maxParameterValue));
    }

    @Override
    public ITextDisplay setCell(int row, int cell, String value) {
        this.cells[row * 8 + cell] = StringUtils.pad(value, 8, ' ') + (cell % 2 == 0 ? " " : "");
        return this;
    }

    @Override
    protected String convertCharacterset(String text) {
        String t = text.replace(BARS_NON, "-").replace(BARS_ONE, "|").replace(BARS_TWO, "|").replace(BARS_ONE_L, "|").replace(SELECT_ARROW, ">").replace(RIGHT_ARROW, ">");
        StringBuilder sb = new StringBuilder(t.length());
        int beginIndex = 0;
        int endIndex = 17;
        for (int i = 0; i < 4; ++i) {
            sb.append(t.substring(beginIndex, endIndex));
            beginIndex += 17;
            endIndex += 17;
            if (i == 3) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    @Override
    public void writeLine(int row, String text, String previousText) {
        this.output.sendSysex(SYSEX_MESSAGE[row] + StringUtils.asciiToHex(text) + "F7");
    }

    private static String formatStr(int value, Format format, int maxParam) {
        switch (format) {
            case FORMAT_VALUE: {
                return Push1Display.formatValue(value, maxParam);
            }
            case FORMAT_PAN: {
                return Push1Display.formatPan(value, maxParam);
            }
        }
        return Integer.toString(value);
    }

    public static String formatValue(int value, int maxParam) {
        StringBuilder n = new StringBuilder();
        Arrays.asList(Push1Display.fillFields(value, maxParam)).forEach(n::append);
        return n.toString();
    }

    public static String formatValue(int modulated, int value, int maxParam) {
        String[] fields = Push1Display.fillFields(value, maxParam);
        int noOfBarsModulated = (int)Math.round(16.0 * (double)modulated / (double)maxParam);
        int pos = noOfBarsModulated / 2;
        if (noOfBarsModulated % 2 == 0) {
            if (pos > 0) {
                if (fields[pos - 1].charAt(0) == BARS_NON.charAt(0)) {
                    fields[pos - 1] = BARS_ONE_L;
                } else if (fields[pos].charAt(0) == BARS_ONE.charAt(0)) {
                    fields[pos - 1] = BARS_TWO;
                }
            }
        } else {
            fields[pos] = fields[pos].charAt(0) == BARS_NON.charAt(0) ? BARS_ONE : BARS_TWO;
        }
        StringBuilder n = new StringBuilder();
        Arrays.asList(fields).forEach(n::append);
        return n.toString();
    }

    private static String[] fillFields(int value, int maxParam) {
        Object[] fields = new String[8];
        Arrays.fill(fields, BARS_NON);
        int noOfBars = (int)Math.round(16.0 * (double)value / (double)maxParam);
        for (int count = 0; count < noOfBars / 2; ++count) {
            fields[count] = BARS_TWO;
        }
        if (noOfBars % 2 == 1) {
            fields[count] = BARS_ONE;
        }
        return fields;
    }

    private static String formatPan(int pan, int maxParam) {
        int middle = maxParam / 2;
        if (pan == middle) {
            return NON_4 + NON_4;
        }
        boolean isLeft = pan < middle;
        int pos = isLeft ? middle - pan : pan - middle;
        int noOfBars = 16 * pos / maxParam;
        StringBuilder n = new StringBuilder();
        for (int i = 0; i < noOfBars / 2; ++i) {
            n.append(BARS_TWO);
        }
        if (pan >= maxParam - 1) {
            n.append(BARS_TWO);
        } else if (noOfBars % 2 == 1) {
            n.append(isLeft ? BARS_ONE_L : BARS_ONE);
        }
        n = new StringBuilder(NON_4).append(StringUtils.pad(n.toString(), 4, BARS_NON.charAt(0)));
        return isLeft ? n.reverse().toString() : n.toString();
    }

    public static List<Pair<String, Boolean>> createMenuList(int displaySize, String[] elements, int selectedIndex) {
        ArrayList<Pair<String, Boolean>> menu = new ArrayList<Pair<String, Boolean>>();
        int startIndex = Math.max(0, Math.min(selectedIndex, elements.length - displaySize));
        for (int i = 0; i < displaySize; ++i) {
            int pos = startIndex + i;
            String itemName = pos < elements.length ? elements[pos] : "";
            menu.add(new Pair<String, Boolean>(itemName, pos == selectedIndex));
        }
        return menu;
    }

    @Override
    protected void updateNotification() {
        int blockLength = 17;
        String trimmed = this.notificationMessage.trim();
        int length = trimmed.length();
        if (length > 17) {
            super.updateNotification();
            return;
        }
        String text = this.currentMessage[0].substring(0, this.noOfCharacters - 17) + StringUtils.pad(trimmed, 17);
        this.updateLine(0, text, this.currentMessage[0]);
        text = this.currentMessage[1].substring(0, this.noOfCharacters - 17) + StringUtils.pad("", 17);
        this.updateLine(1, text, this.currentMessage[1]);
    }
}

