/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.command.trigger;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.command.trigger.Direction;
import de.mossgrabers.framework.command.trigger.mode.CursorCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.view.Views;

public class PushCursorCommand
extends CursorCommand<PushControlSurface, PushConfiguration> {
    private final ISceneBank sceneBank64;

    public PushCursorCommand(Direction direction, IModel model, PushControlSurface surface) {
        super(direction, model, surface, false);
        this.sceneBank64 = model.getSceneBank(64);
    }

    @Override
    protected void scrollUp() {
        ISceneBank sceneBank = this.getSceneBank();
        if (((PushControlSurface)this.surface).isShiftPressed() || this.isScenePlay()) {
            sceneBank.selectPreviousPage();
        } else {
            sceneBank.scrollBackwards();
        }
    }

    @Override
    protected void scrollDown() {
        ISceneBank sceneBank = this.getSceneBank();
        if (((PushControlSurface)this.surface).isShiftPressed() || this.isScenePlay()) {
            sceneBank.selectNextPage();
        } else {
            sceneBank.scrollForwards();
        }
    }

    @Override
    protected void scrollLeft() {
        IMode activeMode = (IMode)((PushControlSurface)this.surface).getModeManager().getActive();
        if (activeMode != null) {
            activeMode.selectPreviousItemPage();
        }
    }

    @Override
    protected void scrollRight() {
        IMode activeMode = (IMode)((PushControlSurface)this.surface).getModeManager().getActive();
        if (activeMode != null) {
            activeMode.selectNextItemPage();
        }
    }

    @Override
    protected ISceneBank getSceneBank() {
        if (this.isScenePlay()) {
            return this.sceneBank64;
        }
        return this.model.getCurrentTrackBank().getSceneBank();
    }

    @Override
    protected void updateArrowStates() {
        ISceneBank sceneBank = this.getSceneBank();
        IMode mode = (IMode)((PushControlSurface)this.surface).getModeManager().getActive();
        boolean shiftPressed = ((PushControlSurface)this.surface).isShiftPressed();
        this.scrollStates.setCanScrollUp(sceneBank.canScrollBackwards());
        this.scrollStates.setCanScrollDown(sceneBank.canScrollForwards());
        this.scrollStates.setCanScrollLeft(mode != null && (shiftPressed ? mode.hasPreviousItem() : mode.hasPreviousItemPage()));
        this.scrollStates.setCanScrollRight(mode != null && (shiftPressed ? mode.hasNextItem() : mode.hasNextItemPage()));
    }

    private boolean isScenePlay() {
        return ((PushControlSurface)this.surface).getViewManager().isActive(new Views[]{Views.SCENE_PLAY});
    }
}

