/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.command.trigger;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class LayoutCommand
extends AbstractTriggerCommand<PushControlSurface, PushConfiguration> {
    public LayoutCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
        if (viewManager.isActive(new Views[]{Views.PLAY})) {
            this.activatePreferredView(Views.CHORDS);
        } else if (viewManager.isActive(new Views[]{Views.CHORDS})) {
            this.activatePreferredView(Views.PIANO);
        } else if (viewManager.isActive(new Views[]{Views.PIANO})) {
            this.activatePreferredView(Views.DRUM64);
        } else if (viewManager.isActive(new Views[]{Views.DRUM64})) {
            this.activatePreferredView(Views.PLAY);
        } else if (viewManager.isActive(new Views[]{Views.SEQUENCER})) {
            this.activatePreferredView(Views.RAINDROPS);
        } else if (viewManager.isActive(new Views[]{Views.RAINDROPS})) {
            this.activatePreferredView(Views.DRUM);
        } else if (viewManager.isActive(new Views[]{Views.DRUM})) {
            this.activatePreferredView(Views.DRUM4);
        } else if (viewManager.isActive(new Views[]{Views.DRUM4})) {
            this.activatePreferredView(Views.DRUM8);
        } else if (viewManager.isActive(new Views[]{Views.DRUM8})) {
            this.activatePreferredView(Views.SEQUENCER);
        } else {
            PushConfiguration configuration = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
            if (viewManager.isActive(new Views[]{Views.SESSION})) {
                if (configuration.isFlipSession()) {
                    viewManager.setActive(Views.SCENE_PLAY);
                } else {
                    configuration.setFlipSession(true);
                }
            } else if (viewManager.isActive(new Views[]{Views.SCENE_PLAY})) {
                configuration.setFlipSession(false);
                viewManager.setActive(Views.SESSION);
            }
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
        if (Views.isSequencerView((Views)((Object)viewManager.getActiveID()))) {
            this.activatePreferredView(Views.PLAY);
        } else if (viewManager.get(Views.SEQUENCER) != null) {
            this.activatePreferredView(Views.SEQUENCER);
        }
    }
}

